

<?php $__env->startSection('title'); ?>
    <?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
    <!-- summernote -->
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/summernote/summernote-bs4.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('back-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 text-dark"><?php echo e($title); ?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
                        <li class="breadcrumb-item active">All <?php echo e($title); ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <form action="<?php echo e(route('admin.lottery.store')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="card card-primary">
                            <div class="card-header">
                                <h3 class="card-title">New <?php echo e($title); ?></h3>
                            </div>
                            <div class="card-body row">
                                
                                <div class="form-group col-lg-8 col-md-8 col-12">
                                    <label for="title">Name</label>
                                    <input type="text" class="form-control" id="title" name="title" placeholder="Name">
                                </div>
                                
                                <div class="form-group col-lg-4 col-md-4 col-12">
                                    <label for="price">Price($)</label>
                                    <input type="number" step="0.25" class="form-control" id="price" name="price" value="0" min="0">
                                </div>
                                
                                <div class="form-group col-lg-4 col-md-4 col-12">
                                    <label for="winner">Winner</label>
                                    <input type="number" step="0.25" class="form-control" id="winner" name="winner" value="0" min="0">
                                </div>
                                    
                                <div class="form-group col-lg-4 col-md-4 col-12">
                                    <label for="start_time">Start Time</label>
                                    <input type="datetime-local" class="form-control" id="start_time" name="start_time" required>
                                </div>
                                    
                                <div class="form-group col-lg-4 col-md-4 col-12">
                                    <label for="end_time">Start Time</label>
                                    <input type="datetime-local" class="form-control" id="end_time" name="end_time" required>
                                </div>
                                
                                <div class="form-group col-12">
                                    <label for="image">Banner</label>
                                    <input type="file" class="form-control" id="image" name="image">
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="col-12">
                    <div class="card card-success">
                        <div class="card-header">
                            <h3 class="card-title">All <?php echo e($title); ?></h3>
                        </div>
                        <div class="card-body">
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th width="5%">#</th>
                                        <th>Banner</th>
                                        <th>Title</th>
                                        <th>Price ($)</th>
                                        <th>Winner</th>
                                        <th>Start Time</th>
                                        <th>End Time</th>
                                        <th class="text-center">Ticket Sold</th>
                                        <th>Status</th>
                                        <th width="10%">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($key + 1); ?></td>
                                            <td>
                                                <img src="<?php echo e(URL::to($data->image)); ?>" width="200" height="160"/>
                                            </td>
                                            <td><?php echo e($data->title); ?></td>
                                            <td><?php echo e($data->price); ?> $</td>
                                            <td><?php echo e($data->winner); ?></td>
                                            <td><?php echo e(\Carbon\Carbon::parse($data->start_time)->format('d/m/Y g:i A')); ?></td>
                                            <td><?php echo e(\Carbon\Carbon::parse($data->end_time)->format('d/m/Y g:i A')); ?></td>
                                            <td class="text-center">
                                                <?php echo e(total_sold_lottery_ticket($data->id)); ?>

                                                <a href="<?php echo e(route('admin.lottery-bought-user',$data->id)); ?>" class="btn btn-success btn-sm">View User</a>
                                            </td>
                                            <td>
                                                <?php if($data->status == 1): ?>
                                                    <label class="text-success"><strong>Running</strong></label>
                                                <?php else: ?>
                                                    <a href="<?php echo e(route('admin.lottery.active',$data->id)); ?>" class="btn btn-info btn-sm">Start Now</a>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <a href="javascript:;" class="btn btn-success btn-sm" data-toggle="modal" data-target="#edit_<?php echo e($key); ?>">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <a href="<?php echo e(route('admin.lottery.delete',$data->id)); ?>" class="btn btn-danger btn-sm"><i class="fas fa-trash-alt"></i></a>
                                            </td>
                                        </tr>
                                        <div class="modal fade" id="edit_<?php echo e($key); ?>" tabindex="-1" role="dialog" aria-labelledby="divisionEditModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-lg" role="document">
                                                <form action="<?php echo e(route('admin.lottery.update', $data->id)); ?>" method="POST" enctype="multipart/form-data">
                                                    <?php echo csrf_field(); ?>
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLabel">Update <?php echo e($title); ?></h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body row">
                                                            <div class="form-group col-12">
                                                                <label for="title">Name</label>
                                                                <input type="text" class="form-control" id="" name="title" value="<?php echo e($data->title); ?>" placeholder="Name">
                                                            </div>
                                                            
                                                            <div class="form-group col-12">
                                                                <label for="price">Price($)</label>
                                                                <input type="number" step="0.25" class="form-control" id="" name="price" value="<?php echo e($data->price); ?>" min="0">
                                                            </div>
                                                            
                                                            <div class="form-group col-lg-4 col-md-4 col-12">
                                                                <label for="winner">Winner</label>
                                                                <input type="number" step="0.25" class="form-control" name="winner" value="<?php echo e($data->winner); ?>" min="0">
                                                            </div>
                                                                
                                                            <div class="form-group col-lg-4 col-md-4 col-12">
                                                                <label for="start_time">Start Time</label>
                                                                <input type="datetime-local" class="form-control" name="start_time" value="<?php echo e($data->start_time); ?>" required>
                                                            </div>
                                                                
                                                            <div class="form-group col-lg-4 col-md-4 col-12">
                                                                <label for="end_time">Start Time</label>
                                                                <input type="datetime-local" class="form-control" name="end_time" value="<?php echo e($data->end_time); ?>" required>
                                                            </div>
                                                            
                                                            <div class="form-group col-12">
                                                                <label for="image">Banner</label>
                                                                <input type="file" class="form-control mb-2" id="" name="image">
                                                                <img src="<?php echo e(URL::to($data->image)); ?>" width="200" height="160"/>
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                            <button type="submit" class="btn btn-primary">Update</button>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('backend/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Summernote -->
    <script src="<?php echo e(asset('backend/plugins/summernote/summernote-bs4.min.js')); ?>"></script>

    <script>
        $(function() {
            $("#example1").DataTable({
                "responsive": true,
                "autoWidth": false,
            });
            $('#example2').DataTable({
                "paging": true,
                "lengthChange": false,
                "searching": false,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "responsive": true,
            });
        });
        // text editor---------------
        $(function () {
            // Summernote
            $('.summernote').summernote();
        })

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dealruom/microjob.dealingwork.com/resources/views/backend/pages/lottery/index.blade.php ENDPATH**/ ?>